/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.improvedmobs.events;

import com.flemmli97.improvedmobs.ai.BlockBreakGoal;
import com.flemmli97.improvedmobs.ai.FlyRidingGoal;
import com.flemmli97.improvedmobs.ai.IGoalModifier;
import com.flemmli97.improvedmobs.ai.ItemUseGoal;
import com.flemmli97.improvedmobs.ai.LadderClimbGoal;
import com.flemmli97.improvedmobs.ai.StealGoal;
import com.flemmli97.improvedmobs.ai.WaterRidingGoal;
import com.flemmli97.improvedmobs.capability.PlayerDifficultyData;
import com.flemmli97.improvedmobs.capability.TileCap;
import com.flemmli97.improvedmobs.capability.TileCapProvider;
import com.flemmli97.improvedmobs.commands.IMCommand;
import com.flemmli97.improvedmobs.config.Config;
import com.flemmli97.improvedmobs.config.EntityModifyFlagConfig;
import com.flemmli97.improvedmobs.difficulty.DifficultyData;
import com.flemmli97.improvedmobs.mixin.MobEntityMixin;
import com.flemmli97.improvedmobs.mixin.NearestTargetGoalMixin;
import com.flemmli97.improvedmobs.mixin.TargetGoalMixin;
import com.flemmli97.improvedmobs.utils.GeneralHelperMethods;
import com.flemmli97.improvedmobs.utils.IMAttributes;
import com.flemmli97.improvedmobs.utils.INodeBreakable;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    public static final ResourceLocation tileCap = new ResourceLocation("improvedmobs", "opened_flag");
    public static final ResourceLocation playerCap = new ResourceLocation("improvedmobs", "player_difficulty");
    public static final String breaker = "improvedmobs:Breaker";
    public static final String flyer = "improvedmobs:Flyer";
    private static final String modifyArmor = "improvedmobs:ModifyArmor";
    private static final String modifyHeld = "improvedmobs:ModifyHeld";
    private static final String modifyAttributes = "improvedmobs:ModifyAttr";
    private static final String enchanted = "improvedmobs:DoEnchant";

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<TileEntity> event) {
        event.addCapability(tileCap, (ICapabilityProvider)new TileCap());
    }

    @SubscribeEvent
    public void attachCapabilityPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ServerPlayerEntity) {
            event.addCapability(playerCap, (ICapabilityProvider)new PlayerDifficultyData());
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld && ((ServerWorld)event.getWorld()).func_234923_W_() == World.field_234918_g_) {
            Config.CommonConfig.serverInit((ServerWorld)event.getWorld());
        }
    }

    @SubscribeEvent
    public void commands(RegisterCommandsEvent event) {
        IMCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void entityProps(EntityEvent.EntityConstructing e) {
        if (e.getEntity().field_70170_p != null && !e.getEntity().field_70170_p.field_72995_K && e.getEntity() instanceof MobEntity) {
            MobEntity living = (MobEntity)e.getEntity();
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.ARMOR, Config.CommonConfig.armorMobWhitelist)) {
                living.getPersistentData().func_74757_a(modifyArmor, true);
            }
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.HELDITEMS, Config.CommonConfig.heldMobWhitelist)) {
                living.getPersistentData().func_74757_a(modifyHeld, true);
            }
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.ATTRIBUTES, Config.CommonConfig.mobAttributeWhitelist)) {
                living.getPersistentData().func_74757_a(modifyAttributes, true);
            }
        }
    }

    @SubscribeEvent
    public void entityProps(LivingSpawnEvent.CheckSpawn e) {
        if (e.getEntity() instanceof MobEntity && !e.getWorld().func_201670_d() && GeneralHelperMethods.isMobInList((MobEntity)e.getEntity(), Config.CommonConfig.mobListLight, Config.CommonConfig.mobListLightBlackList)) {
            int light = e.getWorld().func_226658_a_(LightType.BLOCK, e.getEntity().func_233580_cy_());
            if (light >= Config.CommonConfig.light) {
                e.setResult(Event.Result.DENY);
            } else {
                e.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onEntityLoad(EntityJoinWorldEvent e) {
        CreatureEntity creature;
        if (e.getWorld().field_72995_K) {
            return;
        }
        if (e.getEntity() instanceof MobEntity && e.getEntity().getPersistentData().func_74767_n("improvedmobs:water_riding")) {
            MobEntity boat = (MobEntity)e.getEntity();
            boat.getPersistentData().func_74757_a(modifyArmor, false);
            boat.getPersistentData().func_74757_a(modifyHeld, false);
            if (!boat.getPersistentData().func_74764_b(modifyAttributes) || boat.getPersistentData().func_74767_n(modifyAttributes)) {
                boat.getPersistentData().func_74757_a(modifyAttributes, false);
                ModifiableAttributeInstance inst = boat.func_110148_a(Attributes.field_233818_a_);
                if (inst != null) {
                    inst.func_111128_a(5.0);
                }
                boat.func_70606_j(boat.func_110138_aP());
            }
            ((IGoalModifier)boat.field_70714_bg).goalRemovePredicate(g -> !(g instanceof LookAtGoal) && !(g instanceof RandomWalkingGoal) && !(g instanceof RandomSwimmingGoal));
            ((IGoalModifier)boat.field_70715_bh).goalRemovePredicate(g -> true);
            return;
        }
        boolean mobGriefing = e.getWorld().func_82736_K().func_223586_b(GameRules.field_223599_b);
        if (e.getEntity() instanceof MobEntity) {
            List<EntityType<?>> types;
            boolean aggressive;
            boolean villager;
            MobEntity living = (MobEntity)e.getEntity();
            if (!living.getPersistentData().func_74764_b(breaker)) {
                if (DifficultyData.getDifficulty(living.field_70170_p, (LivingEntity)living) >= Config.CommonConfig.difficultyBreak && Config.CommonConfig.breakerChance != 0.0f && e.getEntity().field_70170_p.field_73012_v.nextFloat() < Config.CommonConfig.breakerChance && !Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.BLOCKBREAK, Config.CommonConfig.mobListBreakWhitelist)) {
                    living.getPersistentData().func_74757_a(breaker, true);
                } else {
                    living.getPersistentData().func_74757_a(breaker, false);
                }
            }
            if (!living.getPersistentData().func_74764_b(flyer)) {
                if (living.field_70170_p.field_73012_v.nextFloat() < Config.CommonConfig.flyAIChance && !Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.PARROT, Config.CommonConfig.mobListFlyWhitelist)) {
                    living.getPersistentData().func_74757_a(flyer, true);
                } else {
                    living.getPersistentData().func_74757_a(flyer, false);
                }
            }
            boolean canBreak = living.getPersistentData().func_74767_n(breaker);
            boolean canFly = living.getPersistentData().func_74767_n(flyer);
            this.applyAttributesAndItems(living);
            if (canBreak) {
                ((IGoalModifier)living.field_70715_bh).modifyGoal(NearestAttackableTargetGoal.class, g -> {
                    if (g instanceof NearestAttackableTargetGoal && (double)living.field_70170_p.field_73012_v.nextFloat() < 0.5) {
                        ((TargetGoalMixin)g).setShouldCheckSight(false);
                        ((NearestTargetGoalMixin)g).getTargetEntitySelector().func_221014_c();
                    }
                });
                if (mobGriefing) {
                    living.field_70714_bg.func_75776_a(1, (Goal)new BlockBreakGoal(living));
                    if (living.func_70661_as() == null || living.func_70661_as().func_189566_q() == null) {
                        throw new NullPointerException("Navigator null! " + living + " ; " + living.func_70661_as());
                    }
                    ((INodeBreakable)living.func_70661_as().func_189566_q()).setCanBreakBlocks(true);
                    ItemStack stack = Config.CommonConfig.getRandomBreakingItem(living.func_70681_au());
                    if (!Config.CommonConfig.shouldDropEquip) {
                        stack.func_77966_a(Enchantments.field_190940_C, 1);
                    }
                    living.func_184201_a(EquipmentSlotType.OFFHAND, stack);
                }
            }
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.USEITEM, Config.CommonConfig.mobListUseWhitelist)) {
                living.field_70714_bg.func_75776_a(1, (Goal)new ItemUseGoal(living, 15.0f));
            }
            if (canFly && !(((MobEntityMixin)living).getTrueNavigator() instanceof FlyingPathNavigator) && !(living instanceof SlimeEntity)) {
                living.field_70714_bg.func_75776_a(6, (Goal)new FlyRidingGoal(living));
            }
            if (living.field_70170_p.field_73012_v.nextFloat() < Config.CommonConfig.guardianAIChance && !Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.GUARDIAN, Config.CommonConfig.mobListBoatWhitelist) && !(((MobEntityMixin)living).getTrueNavigator() instanceof SwimmerPathNavigator) && !(living instanceof SlimeEntity)) {
                living.field_70714_bg.func_75776_a(6, (Goal)new WaterRidingGoal(living));
            }
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.LADDER, Config.CommonConfig.mobListLadderWhitelist) && !(living.func_70661_as() instanceof ClimberPathNavigator)) {
                ((INodeBreakable)living.func_70661_as().func_189566_q()).setCanClimbLadder(true);
                living.field_70714_bg.func_75776_a(4, (Goal)new LadderClimbGoal(living));
            }
            boolean bl = villager = !Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.TARGETVILLAGER, Config.CommonConfig.targetVillagerWhitelist);
            if (living instanceof IAngerable && !Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.NEUTRALAGGRO, Config.CommonConfig.neutralAggroWhitelist)) {
                boolean bl2 = aggressive = Config.CommonConfig.neutralAggressiv != 0.0f && living.field_70170_p.field_73012_v.nextFloat() < Config.CommonConfig.neutralAggressiv;
                if (aggressive) {
                    living.field_70715_bh.func_75776_a(1, this.setNoLoS(living, PlayerEntity.class, !canBreak || (double)living.field_70170_p.field_73012_v.nextFloat() < 0.5, null));
                }
            } else {
                aggressive = true;
            }
            if (villager && aggressive) {
                ((IGoalModifier)living.field_70715_bh).goalRemovePredicate(g -> g instanceof NearestTargetGoalMixin && ((NearestTargetGoalMixin)g).targetTypeClss() == AbstractVillagerEntity.class);
                living.field_70715_bh.func_75776_a(3, this.setNoLoS(living, AbstractVillagerEntity.class, !canBreak || (double)living.field_70170_p.field_73012_v.nextFloat() < 0.5, null));
            }
            if ((types = Config.CommonConfig.autoTargets.get(living.func_200600_R().getRegistryName())) != null) {
                living.field_70715_bh.func_75776_a(3, this.setNoLoS(living, LivingEntity.class, !canBreak || (double)living.field_70170_p.field_73012_v.nextFloat() < 0.5, l -> types.contains(l.func_200600_R())));
            }
        }
        if (e.getEntity() instanceof CreatureEntity && DifficultyData.getDifficulty(creature.field_70170_p, (LivingEntity)(creature = (CreatureEntity)e.getEntity())) >= Config.CommonConfig.difficultySteal && mobGriefing && Config.CommonConfig.stealerChance != 0.0f && e.getEntity().field_70170_p.field_73012_v.nextFloat() < Config.CommonConfig.stealerChance && !Config.CommonConfig.entityBlacklist.hasFlag((MobEntity)creature, EntityModifyFlagConfig.Flags.STEAL, Config.CommonConfig.mobListStealWhitelist)) {
            creature.field_70714_bg.func_75776_a(5, (Goal)new StealGoal(creature));
        }
    }

    private <T extends LivingEntity> NearestAttackableTargetGoal<T> setNoLoS(MobEntity e, Class<T> clss, boolean sight, Predicate<LivingEntity> pred) {
        NearestAttackableTargetGoal goal = pred == null ? new NearestAttackableTargetGoal(e, clss, sight) : new NearestAttackableTargetGoal(e, clss, 10, sight, false, pred);
        if (!sight) {
            ((NearestTargetGoalMixin)goal).getTargetEntitySelector().func_221014_c();
        }
        return goal;
    }

    private void applyAttributesAndItems(MobEntity living) {
        if (living.getPersistentData().func_74767_n(modifyArmor)) {
            GeneralHelperMethods.equipArmor(living);
            living.getPersistentData().func_74757_a(modifyArmor, false);
        }
        if (living.getPersistentData().func_74767_n(modifyHeld)) {
            GeneralHelperMethods.equipHeld(living);
            living.getPersistentData().func_74757_a(modifyHeld, false);
        }
        if (!living.getPersistentData().func_74764_b(enchanted)) {
            GeneralHelperMethods.enchantGear(living);
            living.getPersistentData().func_74757_a(enchanted, true);
        }
        if (living.getPersistentData().func_74767_n(modifyAttributes)) {
            float difficulty = DifficultyData.getDifficulty(living.field_70170_p, (LivingEntity)living);
            if (Config.CommonConfig.healthIncrease != 0.0 && !Config.CommonConfig.useScalingHealthMod) {
                GeneralHelperMethods.modifyAttr(living, Attributes.field_233818_a_, Config.CommonConfig.healthIncrease * 0.016, Config.CommonConfig.healthMax, difficulty, true);
                living.func_70606_j(living.func_110138_aP());
            }
            if (Config.CommonConfig.damageIncrease != 0.0 && !Config.CommonConfig.useScalingHealthMod) {
                GeneralHelperMethods.modifyAttr(living, Attributes.field_233823_f_, Config.CommonConfig.damageIncrease * 0.008, Config.CommonConfig.damageMax, difficulty, true);
            }
            if (Config.CommonConfig.speedIncrease != 0.0) {
                GeneralHelperMethods.modifyAttr(living, Attributes.field_233821_d_, Config.CommonConfig.speedIncrease * 8.0E-4, Config.CommonConfig.speedMax, difficulty, false);
            }
            if (Config.CommonConfig.knockbackIncrease != 0.0) {
                GeneralHelperMethods.modifyAttr(living, Attributes.field_233820_c_, Config.CommonConfig.knockbackIncrease * 0.002, Config.CommonConfig.knockbackMax, difficulty, false);
            }
            if (Config.CommonConfig.magicResIncrease != 0.0f) {
                IMAttributes.apply(living, IMAttributes.Attribute.MAGIC_RES, Math.min(Config.CommonConfig.magicResIncrease * 0.0016f * difficulty, Config.CommonConfig.magicResMax));
            }
            if (Config.CommonConfig.projectileIncrease != 0.0f) {
                IMAttributes.apply(living, IMAttributes.Attribute.PROJ_BOOST, Config.CommonConfig.projectileMax <= 0.0f ? Config.CommonConfig.projectileIncrease * 0.008f * difficulty : Math.min(Config.CommonConfig.projectileIncrease * 0.008f * difficulty, Config.CommonConfig.projectileIncrease - 1.0f));
            }
            living.getPersistentData().func_74757_a(modifyAttributes, false);
        }
    }

    @SubscribeEvent
    public void hurtEvent(LivingHurtEvent e) {
        DamageSource source = e.getSource();
        if (source.func_76352_a() && source.func_76346_g() instanceof MonsterEntity) {
            e.setAmount(e.getAmount() * (1.0f + IMAttributes.get((MobEntity)source.func_76346_g(), IMAttributes.Attribute.PROJ_BOOST)));
        }
        if (e.getEntity() instanceof MonsterEntity && e.getSource().func_82725_o()) {
            e.setAmount(e.getAmount() * (1.0f - IMAttributes.get((MobEntity)e.getEntity(), IMAttributes.Attribute.MAGIC_RES)));
        }
    }

    @SubscribeEvent
    public void removeBoats(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof MobEntity && event.getEntity().getPersistentData().func_74767_n("improvedmobs:water_riding") && !event.getEntity().func_184207_aI()) {
            event.getEntity().func_70106_y();
        }
    }

    @SubscribeEvent
    public void pathDebug(LivingEvent e) {
        Path path;
        if (Config.CommonConfig.debugPath && e.getEntity() instanceof MobEntity && !e.getEntity().field_70170_p.field_72995_K && (path = ((MobEntity)e.getEntity()).func_70661_as().func_75505_d()) != null) {
            for (int i = 0; i < path.func_75874_d(); ++i) {
                ((ServerWorld)e.getEntity().field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197597_H, (double)path.func_75877_a((int)i).field_75839_a + 0.5, (double)path.func_75877_a((int)i).field_75837_b + 0.2, (double)path.func_75877_a((int)i).field_75838_c + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
            ((ServerWorld)e.getEntity().field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, (double)path.func_75870_c().field_75839_a + 0.5, (double)path.func_75870_c().field_75837_b + 0.2, (double)path.func_75870_c().field_75838_c + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @SubscribeEvent
    public void attackEvent(LivingAttackEvent e) {
        if (!e.getEntity().field_70170_p.field_72995_K) {
            LivingEntity attacker;
            if (!Config.CommonConfig.friendlyFire && e.getEntityLiving() instanceof TameableEntity) {
                TameableEntity pet = (TameableEntity)e.getEntity();
                if (e.getSource().func_76346_g() != null && e.getSource().func_76346_g() == pet.func_70902_q() && !e.getSource().func_76346_g().func_225608_bj_()) {
                    e.setCanceled(true);
                    return;
                }
            }
            Entity source = e.getSource().func_76346_g();
            if (e.getEntityLiving() instanceof PlayerEntity) {
                Entity direct = e.getSource().func_76364_f();
                if (direct instanceof SnowballEntity && direct.getPersistentData().func_74767_n("improvedmobs:thrown_entity")) {
                    direct.getPersistentData().func_82580_o("improvedmobs:thrown_entity");
                    e.getEntity().func_70097_a(e.getSource(), 0.001f);
                }
            } else if (source instanceof LivingEntity && (attacker = (LivingEntity)source).func_184614_ca().canDisableShield(e.getEntityLiving().func_184607_cu(), e.getEntityLiving(), attacker)) {
                EventHandler.triggerDisableShield(attacker, e.getEntityLiving());
            }
        }
    }

    private static void triggerDisableShield(LivingEntity attacker, LivingEntity target) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)attacker) * 0.05f;
        if (attacker.func_70051_ag()) {
            f += 0.75f;
        }
        if (attacker.func_70681_au().nextFloat() < f) {
            target.getPersistentData().func_74757_a("improvedmobs:trigger_shield", true);
            target.func_184602_cy();
            target.field_70170_p.func_72960_a((Entity)target, (byte)30);
        }
    }

    @SubscribeEvent
    public void openTile(PlayerInteractEvent.RightClickBlock e) {
        TileEntity tile;
        if (!e.getWorld().field_72995_K && !e.getPlayer().func_225608_bj_() && (tile = e.getWorld().func_175625_s(e.getPos())) != null) {
            tile.getCapability(TileCapProvider.OpenedCap, null).ifPresent(iTileOpened -> iTileOpened.setOpened(tile));
        }
    }

    @SubscribeEvent
    public void equipPet(PlayerInteractEvent.EntityInteract e) {
        if (e.getHand() == Hand.MAIN_HAND && e.getTarget() instanceof MobEntity && e.getTarget() instanceof TameableEntity && !e.getTarget().field_70170_p.field_72995_K && e.getPlayer().func_225608_bj_() && !GeneralHelperMethods.isMobInList((MobEntity)e.getTarget(), Config.CommonConfig.petArmorBlackList, Config.CommonConfig.petWhiteList)) {
            TameableEntity pet = (TameableEntity)e.getTarget();
            if (e.getPlayer() == pet.func_70902_q()) {
                MobEntity living = (MobEntity)e.getTarget();
                ItemStack heldItem = e.getPlayer().func_184614_ca();
                if (heldItem.func_77973_b() instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)heldItem.func_77973_b();
                    EquipmentSlotType type = armor.func_185083_B_();
                    switch (type) {
                        case HEAD: {
                            this.equipPetItem(e.getPlayer(), living, heldItem, EquipmentSlotType.HEAD);
                            break;
                        }
                        case CHEST: {
                            this.equipPetItem(e.getPlayer(), living, heldItem, EquipmentSlotType.CHEST);
                            break;
                        }
                        case LEGS: {
                            this.equipPetItem(e.getPlayer(), living, heldItem, EquipmentSlotType.LEGS);
                            break;
                        }
                        case FEET: {
                            this.equipPetItem(e.getPlayer(), living, heldItem, EquipmentSlotType.FEET);
                            break;
                        }
                    }
                    e.setCanceled(true);
                }
            }
        }
    }

    private void equipPetItem(PlayerEntity player, MobEntity living, ItemStack stack, EquipmentSlotType slot) {
        ItemStack current = living.func_184582_a(slot);
        if (!current.func_190926_b() && !player.func_184812_l_()) {
            ItemEntity entityitem = new ItemEntity(living.field_70170_p, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), current);
            entityitem.func_174868_q();
            living.field_70170_p.func_217376_c((Entity)entityitem);
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(1);
        living.func_184201_a(slot, copy);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent e) {
        EntityRayTraceResult res;
        Entity thrower;
        if (e.getEntity() instanceof ProjectileEntity && e.getEntity().getPersistentData().func_74764_b("improvedmobs:thrown_entity") && (thrower = ((ProjectileEntity)e.getEntity()).func_234616_v_()) instanceof MobEntity && !(e.getEntity() instanceof PotionEntity) && e.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && !(res = (EntityRayTraceResult)e.getRayTraceResult()).func_216348_a().equals((Object)((MobEntity)thrower).func_70638_az())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void explosion(ExplosionEvent.Detonate event) {
        if (event.getExplosion().getExploder() instanceof TNTEntity && event.getExplosion().getExploder().getPersistentData().func_74764_b("improvedmobs:thrown_entity")) {
            event.getAffectedBlocks().clear();
            LivingEntity igniter = event.getExplosion().func_94613_c();
            if (igniter instanceof MobEntity) {
                event.getAffectedEntities().removeIf(e -> !e.equals((Object)((MobEntity)igniter).func_70638_az()));
            }
        }
    }
}

